<?php

/**
 * Class that operate on table 'buybillcurr'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-12-27 23:59
 */
class BuybillcurrMySqlDAO implements BuybillcurrDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BuybillcurrMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM buybillcurr WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM buybillcurr';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM buybillcurr ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param buybillcurr primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM buybillcurr WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BuybillcurrMySql buybillcurr
     */
    public function insert($buybillcurr) {
        $sql = 'INSERT INTO buybillcurr (buybillid, conversionFactor, buybilldiscountC, buybilltotalbillC, buybillaftertotalbillC, buybilltotalpayedC, buybillfinalbillC, buybilldirectpaymentC, payedtaxC, saveConversionFactor,buybilladditionC) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($buybillcurr->buybillid);
        $sqlQuery->set($buybillcurr->conversionFactor);
        $sqlQuery->set($buybillcurr->buybilldiscountC);
        $sqlQuery->set($buybillcurr->buybilltotalbillC);
        $sqlQuery->set($buybillcurr->buybillaftertotalbillC);
        $sqlQuery->set($buybillcurr->buybilltotalpayedC);
        $sqlQuery->set($buybillcurr->buybillfinalbillC);
        $sqlQuery->setNumber($buybillcurr->buybilldirectpaymentC);
        $sqlQuery->set($buybillcurr->payedtaxC);
        $sqlQuery->set($buybillcurr->saveConversionFactor);
        $sqlQuery->setNumber((float) $buybillcurr->buybilladditionC);

        $id = $this->executeInsert($sqlQuery);
        $buybillcurr->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BuybillcurrMySql buybillcurr
     */
    public function update($buybillcurr) {
        $sql = 'UPDATE buybillcurr SET buybillid = ?, conversionFactor = ?, buybilldiscountC = ?, buybilltotalbillC = ?, buybillaftertotalbillC = ?, buybilltotalpayedC = ?, buybillfinalbillC = ?, buybilldirectpaymentC = ?, payedtaxC = ?, saveConversionFactor = ?,buybilladditionC=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($buybillcurr->buybillid);
        $sqlQuery->set($buybillcurr->conversionFactor);
        $sqlQuery->set($buybillcurr->buybilldiscountC);
        $sqlQuery->set($buybillcurr->buybilltotalbillC);
        $sqlQuery->set($buybillcurr->buybillaftertotalbillC);
        $sqlQuery->set($buybillcurr->buybilltotalpayedC);
        $sqlQuery->set($buybillcurr->buybillfinalbillC);
        $sqlQuery->setNumber($buybillcurr->buybilldirectpaymentC);
        $sqlQuery->set($buybillcurr->payedtaxC);
        $sqlQuery->set($buybillcurr->saveConversionFactor);
        $sqlQuery->setNumber((float) $buybillcurr->buybilladditionC);

        $sqlQuery->setNumber($buybillcurr->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM buybillcurr';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuybillid($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConversionFactor($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE conversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldiscountC($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE buybilldiscountC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotalbillC($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE buybilltotalbillC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillaftertotalbillC($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE buybillaftertotalbillC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotalpayedC($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE buybilltotalpayedC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillfinalbillC($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE buybillfinalbillC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldirectpaymentC($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE buybilldirectpaymentC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPayedtaxC($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE payedtaxC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveConversionFactor($value) {
        $sql = 'SELECT * FROM buybillcurr WHERE saveConversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuybillid($value) {
        $sql = 'DELETE FROM buybillcurr WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConversionFactor($value) {
        $sql = 'DELETE FROM buybillcurr WHERE conversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldiscountC($value) {
        $sql = 'DELETE FROM buybillcurr WHERE buybilldiscountC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotalbillC($value) {
        $sql = 'DELETE FROM buybillcurr WHERE buybilltotalbillC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillaftertotalbillC($value) {
        $sql = 'DELETE FROM buybillcurr WHERE buybillaftertotalbillC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotalpayedC($value) {
        $sql = 'DELETE FROM buybillcurr WHERE buybilltotalpayedC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillfinalbillC($value) {
        $sql = 'DELETE FROM buybillcurr WHERE buybillfinalbillC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldirectpaymentC($value) {
        $sql = 'DELETE FROM buybillcurr WHERE buybilldirectpaymentC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPayedtaxC($value) {
        $sql = 'DELETE FROM buybillcurr WHERE payedtaxC = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveConversionFactor($value) {
        $sql = 'DELETE FROM buybillcurr WHERE saveConversionFactor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BuybillcurrMySql
     */
    protected function readRow($row) {
        $buybillcurr = new Buybillcurr();

        $buybillcurr->id = $row['id'];
        $buybillcurr->buybillid = $row['buybillid'];
        $buybillcurr->conversionFactor = $row['conversionFactor'];
        $buybillcurr->buybilldiscountC = $row['buybilldiscountC'];
        $buybillcurr->buybilltotalbillC = $row['buybilltotalbillC'];
        $buybillcurr->buybillaftertotalbillC = $row['buybillaftertotalbillC'];
        $buybillcurr->buybilltotalpayedC = $row['buybilltotalpayedC'];
        $buybillcurr->buybillfinalbillC = $row['buybillfinalbillC'];
        $buybillcurr->buybilldirectpaymentC = $row['buybilldirectpaymentC'];
        $buybillcurr->payedtaxC = $row['payedtaxC'];
        $buybillcurr->saveConversionFactor = $row['saveConversionFactor'];
        $buybillcurr->buybilladditionC = $row['buybilladditionC'];

        return $buybillcurr;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BuybillcurrMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>